// modified version of random-normal
function normalPool(o) {
    var r = 0;
    do {
        var a = Math.round(normal({mean: o.mean, dev: o.dev}));
        if (a < o.pool.length && a >= 0) return o.pool[a];
        r++
    } while (r < 100)
}

function randomNormal(o) {
    if (o = Object.assign({
        mean: 0,
        dev: 1,
        pool: []
    }, o), Array.isArray(o.pool) && o.pool.length > 0) return normalPool(o);
    var r, a, n, e, l = o.mean, t = o.dev;
    do {
        r = (a = 2 * Math.random() - 1) * a + (n = 2 * Math.random() - 1) * n
    } while (r >= 1);
    return e = a * Math.sqrt(-2 * Math.log(r) / r), t * e + l
}

function rand(low, high) {
    return Math.random() * (high - low) + low;
}

function createParticle(canvas, particleSize, speed, color) {
    var result = /^#?([a-f\d]{2})([a-f\d]{2})([a-f\d]{2})$/i.exec(color);
    let color_r = parseInt(result[1], 16);
    let color_g = parseInt(result[2], 16);
    let color_b = parseInt(result[3], 16);
    const colour = {
        r: color_r,
        g: color_g,
        b: color_b,
        a: rand(0, 1),
    };
    return {
        x: -2,
        y: -2,
        diameter: Math.max(0, randomNormal({mean: particleSize, dev: particleSize / 2})),
        duration: randomNormal({mean: speed, dev: speed * 0.1}),
        amplitude: randomNormal({mean: 16, dev: 2}),
        offsetY: randomNormal({mean: 0, dev: 10}),
        arc: Math.PI * 2,
        startTime: performance.now() - rand(0, speed),
        colour: `rgba(${colour.r}, ${colour.g}, ${colour.b}, ${colour.a})`,
    }
}

function moveParticle(particle, canvas, time) {
    const progress = ((time - particle.startTime) % particle.duration) / particle.duration;
    return {
        ...particle,
        x: progress,
        y: ((Math.sin(progress * particle.arc) * particle.amplitude) + particle.offsetY),
    };
}

function drawParticle(coanvasId, particle, canvas, ctx) {
    canvas = document.getElementById(coanvasId);
    if (canvas) {
        const vh = canvas.height / 100;

        ctx.fillStyle = particle.colour;
        ctx.beginPath();
        ctx.ellipse(
            particle.x * canvas.width,
            particle.y * vh + (canvas.height / 2),
            particle.diameter * vh,
            particle.diameter * vh,
            0,
            0,
            2 * Math.PI
        );
        ctx.fill();
    }
}

function draw(time, coanvasId, canvas, ctx, particles) {
    // Move particles
    if (ctx && canvas) {
        particles.forEach((particle, index) => {
            particles[index] = moveParticle(particle, canvas, time);
        })

        // Clear the canvas
        ctx.clearRect(0, 0, canvas.width, canvas.height);

        // Draw the particles
        particles.forEach((particle) => {
            drawParticle(coanvasId, particle, canvas, ctx);
        })

        // Schedule next frame
        requestAnimationFrame((time) => draw(time, coanvasId, canvas, ctx, particles));
    }
}

function initializeCanvas(coanvasId) {
    let canvas = document.getElementById(coanvasId);
    canvas.width = canvas.offsetWidth * window.devicePixelRatio;
    canvas.height = canvas.offsetHeight * window.devicePixelRatio;
    let ctx = canvas.getContext("2d");

    window.addEventListener('resize', () => {
        canvas.width = canvas.offsetWidth * window.devicePixelRatio;
        canvas.height = canvas.offsetHeight * window.devicePixelRatio;
        ctx = canvas.getContext("2d");
    })

    return [canvas, ctx];
}

function startAnimation(coanvasId, particleCount, particleSize, speed, color) {
    const [canvas, ctx] = initializeCanvas(coanvasId);
    let particles = [];
    // Create a bunch of particles
    for (let i = 0; i < particleCount; i++) {
        particles.push(createParticle(canvas, particleSize, speed, color));
    }

    requestAnimationFrame((time) => draw(time, coanvasId, canvas, ctx, particles));
};
